#include <p30fxxxx.h>
#include <incap.h>

/* These devices support Input Capture 7 and Input Capture 8 */
#if defined (__dsPIC30F2010__) || defined (__dsPIC30F3010__) || defined (__dsPIC30F4012__) || \
    defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/********************************************************************
*    Function Name:  ReadCapture7                                   *
*    Description:    This routine reads all pending InputCapture    *
*                    Buffers and stores in the locations specified  *
*    Parameters:     address of locations where buffer data to be   *
*                    stored                                         *
*    Return Value:   None                                           *
********************************************************************/

void ReadCapture7(unsigned int * buffer)
{
	while (IC7CONbits.ICBNE)
	{
		*buffer++ = IC7BUF; /* reads the input capture buffer */
	}
}

#endif 
